
#ifndef EVENTVIEWS_EXPORT_H
#define EVENTVIEWS_EXPORT_H

#ifdef EVENTVIEWS_STATIC_DEFINE
#  define EVENTVIEWS_EXPORT
#  define EVENTVIEWS_NO_EXPORT
#else
#  ifndef EVENTVIEWS_EXPORT
#    ifdef KPim6EventViews_EXPORTS
        /* We are building this library */
#      define EVENTVIEWS_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define EVENTVIEWS_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef EVENTVIEWS_NO_EXPORT
#    define EVENTVIEWS_NO_EXPORT 
#  endif
#endif

#ifndef EVENTVIEWS_DECL_DEPRECATED
#  define EVENTVIEWS_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef EVENTVIEWS_DECL_DEPRECATED_EXPORT
#  define EVENTVIEWS_DECL_DEPRECATED_EXPORT EVENTVIEWS_EXPORT EVENTVIEWS_DECL_DEPRECATED
#endif

#ifndef EVENTVIEWS_DECL_DEPRECATED_NO_EXPORT
#  define EVENTVIEWS_DECL_DEPRECATED_NO_EXPORT EVENTVIEWS_NO_EXPORT EVENTVIEWS_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef EVENTVIEWS_NO_DEPRECATED
#    define EVENTVIEWS_NO_DEPRECATED
#  endif
#endif
#include <eventviews_version.h>

#define EVENTVIEWS_DECL_DEPRECATED_TEXT(text) __declspec(deprecated(text))

#if defined(EVENTVIEWS_NO_DEPRECATED)
#  undef EVENTVIEWS_DEPRECATED
#  define EVENTVIEWS_DEPRECATED_EXPORT EVENTVIEWS_EXPORT
#  define EVENTVIEWS_DEPRECATED_NO_EXPORT EVENTVIEWS_NO_EXPORT
#elif defined(EVENTVIEWS_NO_DEPRECATED_WARNINGS)
#  define EVENTVIEWS_DEPRECATED
#  define EVENTVIEWS_DEPRECATED_EXPORT EVENTVIEWS_EXPORT
#  define EVENTVIEWS_DEPRECATED_NO_EXPORT EVENTVIEWS_NO_EXPORT
#else
#  define EVENTVIEWS_DEPRECATED EVENTVIEWS_DECL_DEPRECATED
#  define EVENTVIEWS_DEPRECATED_EXPORT EVENTVIEWS_DECL_DEPRECATED_EXPORT
#  define EVENTVIEWS_DEPRECATED_NO_EXPORT EVENTVIEWS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define EVENTVIEWS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define EVENTVIEWS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef EVENTVIEWS_NO_DEPRECATED
#  define EVENTVIEWS_DISABLE_DEPRECATED_BEFORE_AND_AT EVENTVIEWS_VERSION
#endif
#ifdef EVENTVIEWS_NO_DEPRECATED_WARNINGS
#  define EVENTVIEWS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef EVENTVIEWS_DEPRECATED_WARNINGS_SINCE
#  ifdef EVENTVIEWS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define EVENTVIEWS_DEPRECATED_WARNINGS_SINCE EVENTVIEWS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define EVENTVIEWS_DEPRECATED_WARNINGS_SINCE EVENTVIEWS_VERSION
#  endif
#endif

#ifndef EVENTVIEWS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define EVENTVIEWS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef EVENTVIEWS_DEPRECATED
#  define EVENTVIEWS_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > EVENTVIEWS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define EVENTVIEWS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* EVENTVIEWS_EXPORT_H */
