
#ifndef KSMTP_EXPORT_H
#define KSMTP_EXPORT_H

#ifdef KSMTP_STATIC_DEFINE
#  define KSMTP_EXPORT
#  define KSMTP_NO_EXPORT
#else
#  ifndef KSMTP_EXPORT
#    ifdef KPim6SMTP_EXPORTS
        /* We are building this library */
#      define KSMTP_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define KSMTP_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef KSMTP_NO_EXPORT
#    define KSMTP_NO_EXPORT 
#  endif
#endif

#ifndef KSMTP_DECL_DEPRECATED
#  define KSMTP_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef KSMTP_DECL_DEPRECATED_EXPORT
#  define KSMTP_DECL_DEPRECATED_EXPORT KSMTP_EXPORT KSMTP_DECL_DEPRECATED
#endif

#ifndef KSMTP_DECL_DEPRECATED_NO_EXPORT
#  define KSMTP_DECL_DEPRECATED_NO_EXPORT KSMTP_NO_EXPORT KSMTP_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KSMTP_NO_DEPRECATED
#    define KSMTP_NO_DEPRECATED
#  endif
#endif
#include <ksmtp_version.h>

#define KSMTP_DECL_DEPRECATED_TEXT(text) __declspec(deprecated(text))

#if defined(KSMTP_NO_DEPRECATED)
#  undef KSMTP_DEPRECATED
#  define KSMTP_DEPRECATED_EXPORT KSMTP_EXPORT
#  define KSMTP_DEPRECATED_NO_EXPORT KSMTP_NO_EXPORT
#elif defined(KSMTP_NO_DEPRECATED_WARNINGS)
#  define KSMTP_DEPRECATED
#  define KSMTP_DEPRECATED_EXPORT KSMTP_EXPORT
#  define KSMTP_DEPRECATED_NO_EXPORT KSMTP_NO_EXPORT
#else
#  define KSMTP_DEPRECATED KSMTP_DECL_DEPRECATED
#  define KSMTP_DEPRECATED_EXPORT KSMTP_DECL_DEPRECATED_EXPORT
#  define KSMTP_DEPRECATED_NO_EXPORT KSMTP_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KSMTP_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KSMTP_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KSMTP_NO_DEPRECATED
#  define KSMTP_DISABLE_DEPRECATED_BEFORE_AND_AT KSMTP_VERSION
#endif
#ifdef KSMTP_NO_DEPRECATED_WARNINGS
#  define KSMTP_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KSMTP_DEPRECATED_WARNINGS_SINCE
#  ifdef KSMTP_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KSMTP_DEPRECATED_WARNINGS_SINCE KSMTP_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KSMTP_DEPRECATED_WARNINGS_SINCE KSMTP_VERSION
#  endif
#endif

#ifndef KSMTP_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KSMTP_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KSMTP_DEPRECATED
#  define KSMTP_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KSMTP_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KSMTP_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KSMTP_EXPORT_H */
