
#ifndef MESSAGECORE_EXPORT_H
#define MESSAGECORE_EXPORT_H

#ifdef MESSAGECORE_STATIC_DEFINE
#  define MESSAGECORE_EXPORT
#  define MESSAGECORE_NO_EXPORT
#else
#  ifndef MESSAGECORE_EXPORT
#    ifdef KPim6MessageCore_EXPORTS
        /* We are building this library */
#      define MESSAGECORE_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define MESSAGECORE_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef MESSAGECORE_NO_EXPORT
#    define MESSAGECORE_NO_EXPORT 
#  endif
#endif

#ifndef MESSAGECORE_DECL_DEPRECATED
#  define MESSAGECORE_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef MESSAGECORE_DECL_DEPRECATED_EXPORT
#  define MESSAGECORE_DECL_DEPRECATED_EXPORT MESSAGECORE_EXPORT MESSAGECORE_DECL_DEPRECATED
#endif

#ifndef MESSAGECORE_DECL_DEPRECATED_NO_EXPORT
#  define MESSAGECORE_DECL_DEPRECATED_NO_EXPORT MESSAGECORE_NO_EXPORT MESSAGECORE_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef MESSAGECORE_NO_DEPRECATED
#    define MESSAGECORE_NO_DEPRECATED
#  endif
#endif
#include <messagecore_version.h>

#define MESSAGECORE_DECL_DEPRECATED_TEXT(text) __declspec(deprecated(text))

#if defined(MESSAGECORE_NO_DEPRECATED)
#  undef MESSAGECORE_DEPRECATED
#  define MESSAGECORE_DEPRECATED_EXPORT MESSAGECORE_EXPORT
#  define MESSAGECORE_DEPRECATED_NO_EXPORT MESSAGECORE_NO_EXPORT
#elif defined(MESSAGECORE_NO_DEPRECATED_WARNINGS)
#  define MESSAGECORE_DEPRECATED
#  define MESSAGECORE_DEPRECATED_EXPORT MESSAGECORE_EXPORT
#  define MESSAGECORE_DEPRECATED_NO_EXPORT MESSAGECORE_NO_EXPORT
#else
#  define MESSAGECORE_DEPRECATED MESSAGECORE_DECL_DEPRECATED
#  define MESSAGECORE_DEPRECATED_EXPORT MESSAGECORE_DECL_DEPRECATED_EXPORT
#  define MESSAGECORE_DEPRECATED_NO_EXPORT MESSAGECORE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define MESSAGECORE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define MESSAGECORE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef MESSAGECORE_NO_DEPRECATED
#  define MESSAGECORE_DISABLE_DEPRECATED_BEFORE_AND_AT MESSAGECORE_VERSION
#endif
#ifdef MESSAGECORE_NO_DEPRECATED_WARNINGS
#  define MESSAGECORE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef MESSAGECORE_DEPRECATED_WARNINGS_SINCE
#  ifdef MESSAGECORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define MESSAGECORE_DEPRECATED_WARNINGS_SINCE MESSAGECORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define MESSAGECORE_DEPRECATED_WARNINGS_SINCE MESSAGECORE_VERSION
#  endif
#endif

#ifndef MESSAGECORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define MESSAGECORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef MESSAGECORE_DEPRECATED
#  define MESSAGECORE_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > MESSAGECORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define MESSAGECORE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* MESSAGECORE_EXPORT_H */
