
#ifndef WEBENGINEVIEWER_EXPORT_H
#define WEBENGINEVIEWER_EXPORT_H

#ifdef WEBENGINEVIEWER_STATIC_DEFINE
#  define WEBENGINEVIEWER_EXPORT
#  define WEBENGINEVIEWER_NO_EXPORT
#else
#  ifndef WEBENGINEVIEWER_EXPORT
#    ifdef KPim6WebEngineViewer_EXPORTS
        /* We are building this library */
#      define WEBENGINEVIEWER_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define WEBENGINEVIEWER_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef WEBENGINEVIEWER_NO_EXPORT
#    define WEBENGINEVIEWER_NO_EXPORT 
#  endif
#endif

#ifndef WEBENGINEVIEWER_DECL_DEPRECATED
#  define WEBENGINEVIEWER_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef WEBENGINEVIEWER_DECL_DEPRECATED_EXPORT
#  define WEBENGINEVIEWER_DECL_DEPRECATED_EXPORT WEBENGINEVIEWER_EXPORT WEBENGINEVIEWER_DECL_DEPRECATED
#endif

#ifndef WEBENGINEVIEWER_DECL_DEPRECATED_NO_EXPORT
#  define WEBENGINEVIEWER_DECL_DEPRECATED_NO_EXPORT WEBENGINEVIEWER_NO_EXPORT WEBENGINEVIEWER_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef WEBENGINEVIEWER_NO_DEPRECATED
#    define WEBENGINEVIEWER_NO_DEPRECATED
#  endif
#endif
#include <webengineviewer_version.h>

#define WEBENGINEVIEWER_DECL_DEPRECATED_TEXT(text) __declspec(deprecated(text))

#if defined(WEBENGINEVIEWER_NO_DEPRECATED)
#  undef WEBENGINEVIEWER_DEPRECATED
#  define WEBENGINEVIEWER_DEPRECATED_EXPORT WEBENGINEVIEWER_EXPORT
#  define WEBENGINEVIEWER_DEPRECATED_NO_EXPORT WEBENGINEVIEWER_NO_EXPORT
#elif defined(WEBENGINEVIEWER_NO_DEPRECATED_WARNINGS)
#  define WEBENGINEVIEWER_DEPRECATED
#  define WEBENGINEVIEWER_DEPRECATED_EXPORT WEBENGINEVIEWER_EXPORT
#  define WEBENGINEVIEWER_DEPRECATED_NO_EXPORT WEBENGINEVIEWER_NO_EXPORT
#else
#  define WEBENGINEVIEWER_DEPRECATED WEBENGINEVIEWER_DECL_DEPRECATED
#  define WEBENGINEVIEWER_DEPRECATED_EXPORT WEBENGINEVIEWER_DECL_DEPRECATED_EXPORT
#  define WEBENGINEVIEWER_DEPRECATED_NO_EXPORT WEBENGINEVIEWER_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define WEBENGINEVIEWER_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define WEBENGINEVIEWER_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef WEBENGINEVIEWER_NO_DEPRECATED
#  define WEBENGINEVIEWER_DISABLE_DEPRECATED_BEFORE_AND_AT WEBENGINEVIEWER_VERSION
#endif
#ifdef WEBENGINEVIEWER_NO_DEPRECATED_WARNINGS
#  define WEBENGINEVIEWER_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef WEBENGINEVIEWER_DEPRECATED_WARNINGS_SINCE
#  ifdef WEBENGINEVIEWER_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define WEBENGINEVIEWER_DEPRECATED_WARNINGS_SINCE WEBENGINEVIEWER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define WEBENGINEVIEWER_DEPRECATED_WARNINGS_SINCE WEBENGINEVIEWER_VERSION
#  endif
#endif

#ifndef WEBENGINEVIEWER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define WEBENGINEVIEWER_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef WEBENGINEVIEWER_DEPRECATED
#  define WEBENGINEVIEWER_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > WEBENGINEVIEWER_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define WEBENGINEVIEWER_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* WEBENGINEVIEWER_EXPORT_H */
