# - Config file for the KDEWin package
# It defines the following variables
#  KDEWIN_DEFINITIONS  - contains the definitions needed to build against kdewin
#  KDEWIN_VERSION      - the version of the kdewin library as a number
#  KDEWIN_VERSION_STR  - the version of the kdewin library as a string
#  KDEWIN_MINGW_W32    - if this library has been compiled with the 32bit compiler of mingw-w64 project
# for usage by configure checks
#  KDEWIN_INCLUDES     - the kdewin include directories
#  KDEWIN_LIBRARIES    - the library target name

get_filename_component(KDEWIN_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

set(KDEWIN_INCLUDE_DIR "${KDEWIN_CMAKE_DIR}/../../../include")
set(KDEWIN_LIBRARY kdewin)
set(KDEWIN_LIBRARIES ${KDEWIN_LIBRARY})
set(KDEWIN_INCLUDES ${KDEWIN_INCLUDE_DIR} ${KDEWIN_INCLUDE_DIR}/msvc)

# Our library dependencies (contains definitions for IMPORTED targets)
include("${KDEWIN_CMAKE_DIR}/KDEWinTargets.cmake")

file(TO_CMAKE_PATH "$ENV{MSSDK}" MSSDK_DIR)

set(KDEWIN_MINGW_W32 OFF)

set(KDEWIN_DEFINITIONS )
set(KDEWIN_VERSION 0x000603)
set(KDEWIN_VERSION_STR 0.6.3)
